<?php
session_start();
$erro = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // ====================================================================
    // A CORREÇÃO ESTÁ AQUI: Usando o caminho local para o XAMPP
    $usuariosFile = __DIR__ . '/../dados_seguros/usuarios.json';
    // ====================================================================

    if (!file_exists($usuariosFile)) {
        $erro = 'Erro: Arquivo de usuários não configurado.';
    } else {
        $usuarios = json_decode(file_get_contents($usuariosFile), true);
        $login_usuario = strtolower(trim($_POST['usuario']));
        $login_senha = $_POST['senha'];
        $user_found = null;
        foreach ($usuarios as $usuario) {
            if (isset($usuario['usuario']) && $usuario['usuario'] === $login_usuario) {
                $user_found = $usuario;
                break;
            }
        }
        if ($user_found && password_verify($login_senha, $user_found['senha_hash'])) {
            $_SESSION['intranet_loggedin'] = true;
            $_SESSION['user_name'] = $user_found['nome'];
            $_SESSION['user_unidade'] = $user_found['unidade'];
            $_SESSION['user_sexo'] = $user_found['sexo'] ?? 'Masculino';
            $_SESSION['user_cargo'] = $user_found['cargo'] ?? 'Colaborador';
            $_SESSION['user_login'] = $user_found['usuario'];
            if (!empty($user_found['aniversario'])) {
                if (date('m-d') === date('m-d', strtotime($user_found['aniversario']))) {
                    $_SESSION['is_birthday'] = true;
                }
            }
            $logFile = __DIR__ . '/../intranet_activity_logs/access_log.csv';
            // Garante que o diretório exista antes de tentar escrever
            if (!is_dir(dirname($logFile))) { mkdir(dirname($logFile), 0755, true); }
            $logData = [date('Y-m-d'), date('H:i:s'), $user_found['usuario'], $user_found['nome']];
            $handle = fopen($logFile, 'a');
            fputcsv($handle, $logData);
            fclose($handle);
            header('Location: index.php');
            exit;
        } else {
            $erro = 'Usuário ou Senha incorretos.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Login - Intranet Biavatti</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --biavatti-dark-blue: #002147;
            --biavatti-accent-blue: #059cee;
            --biavatti-light-bg: #f4f6f8;
            --biavatti-white: #ffffff;
        }
        body {
            margin: 0;
            font-family: 'Poppins', sans-serif;
            overflow: hidden;
        }
        .login-container {
            display: flex;
            width: 100vw;
            height: 100vh;
        }

        /* --- PAINEL DA ESQUERDA (INFORMATIVO) --- */
        .login-info-panel {
            flex: 1;
            position: relative;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: var(--biavatti-white);
            text-align: center;
            padding: 40px;
            box-sizing: border-box;
            overflow: hidden; /* Essencial para o carrossel de fundo */
        }
        
        /* --- NOVO CARROSSEL DE FUNDO --- */
        .background-carousel {
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
            z-index: 0;
        }
        .carousel-track {
            display: flex;
            width: 400%; /* Ajustado por JS (ex: 3 imagens = 300%) */
            height: 100%;
            transition: transform 1.2s ease-in-out;
        }
        .carousel-slide {
            width: 25.000%; /* Ajustado por JS (ex: 3 imagens = 100/3) */
            height: 100%;
            background-size: cover;
            background-position: center;
        }

        .login-info-panel::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background: linear-gradient(to top, rgba(0, 33, 71, 0.8), rgba(5, 156, 238, 0.6));
            z-index: 1;
        }
        .info-content {
            position: relative;
            z-index: 2;
        }
        .info-content img {
            max-width: 650px;
            margin-bottom: 20px;
            filter: brightness(0) invert(1);
        }
        .info-content h1 {
            font-size: 2.2rem;
            margin: 0 0 15px 0;
            font-weight: 600;
        }
        #info-slideshow {
            font-size: 1.1rem;
            font-weight: 300;
            height: 60px;
            transition: opacity 0.5s ease-in-out;
        }
        #info-slideshow.fade-out {
            opacity: 0;
        }

        /* --- PAINEL DA DIREITA (FORMULÁRIO) --- */
        .login-form-panel {
            flex: 1;
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: var(--biavatti-light-bg);
        }
        .login-box {
            width: 100%;
            max-width: 400px;
            padding: 40px;
            box-sizing: border-box;
            text-align: center;
        }
        .login-box h2 { color: var(--biavatti-dark-blue); font-size: 1.8rem; margin-bottom: 30px; }
        .login-box input { width: 100%; padding: 15px; margin-bottom: 20px; border-radius: 8px; border: 1px solid #ccc; box-sizing: border-box; font-size: 1rem; }
        .login-box button { width: 100%; padding: 15px; border: none; border-radius: 50px; background-color: var(--biavatti-accent-blue); color: var(--biavatti-white); font-size: 1.1rem; font-weight: 600; cursor: pointer; transition: background-color 0.3s ease; }
        .login-box button:hover { background-color: var(--biavatti-dark-blue); }
        .error { color: #d9534f; margin-top: 15px; font-weight: bold; }
        
        @media (max-width: 768px) {
            .login-info-panel { display: none; }
            .login-form-panel { flex-basis: 100%; }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-info-panel">
            <div class="background-carousel">
                <div class="carousel-track">
                    <!-- As imagens serão inseridas aqui pelo JavaScript -->
                </div>
            </div>

            <div class="info-content">
                <img src="imagem/cb_logo_bia.png" alt="Logo Clínica Biavatti" />
                <h1>Inovação e Cuidado em Cada Detalhe</h1>
                <br>
                <p id="info-slideshow">Bem-vindo(a) ao nosso espaço digital. Conecte-se com a equipe e com as novidades da clínica.</p>
            </div>
        </div>
        <div class="login-form-panel">
            <div class="login-box">
                <h2>Acesso à Intranet</h2>
                <form method="post">
                    <input type="text" name="usuario" placeholder="Digite seu Usuário" required>
                    <input type="password" name="senha" placeholder="Digite sua Senha (seu CPF)" required>
                    <button type="submit">Entrar</button>
                </form>
                <?php if ($erro): ?>
                    <p class="error"><?php echo $erro; ?></p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
        // ====================== LÓGICA DO CARROSSEL DE FUNDO ======================
        document.addEventListener('DOMContentLoaded', () => {
            // ====> EDITE AQUI: Coloque as URLs das imagens das suas fachadas <====
            const facadeImages = [
                'imagem/CLINICAS/matriz.png',
            ];

            const track = document.querySelector('.carousel-track');
            const numImages = facadeImages.length;

            // Define a largura do track e de cada slide dinamicamente
            track.style.width = `${numImages * 100}%`;
            const slideWidth = 100 / numImages;

            // Cria e insere os slides no carrossel
            facadeImages.forEach(imageUrl => {
                const slide = document.createElement('div');
                slide.className = 'carousel-slide';
                slide.style.width = `${slideWidth}%`;
                slide.style.backgroundImage = `url('${imageUrl}')`;
                track.appendChild(slide);
            });

            let currentImageIndex = 0;
            setInterval(() => {
                currentImageIndex = (currentImageIndex + 1) % numImages;
                const offset = -currentImageIndex * slideWidth;
                track.style.transform = `translateX(${offset}%)`;
            }, 6000); // Troca a imagem a cada 6 segundos
        });


        // ====================== LÓGICA DO SLIDESHOW DE TEXTO ======================
        const infoItems = [
            "Aqui, nós não apenas realçamos a beleza, nós restauramos a confiança.",
            "O sorriso de um paciente satisfeito é a nossa maior recompensa.",
            "Cada detalhe do nosso trabalho reflete o cuidado e a excelência que definem a Rede Biavatti.",
            "Transformamos vidas através da arte da harmonização e do cuidado.",
            "Nosso sucesso é a soma do talento e da dedicação de cada um de vocês.",
            "Oferecemos mais que procedimentos; entregamos jornadas de autoconhecimento e bem-estar.",
            "Juntos, elevamos o padrão da harmonização e do bem-estar no Brasil.",
            "Cada paciente é único. Nossos tratamentos personalizados refletem essa filosofia.",
            "Lembre-se: por trás de cada procedimento, há uma história e um sonho de autoestima.",
            "Da harmonização facial à corporal, a inovação está no nosso DNA.",

        ];
        
        let currentIndex = 0;
        const slideshowElement = document.getElementById('info-slideshow');

        function changeInfo() {
            slideshowElement.classList.add('fade-out');
            setTimeout(() => {
                currentIndex = (currentIndex + 1) % infoItems.length;
                slideshowElement.textContent = infoItems[currentIndex];
                slideshowElement.classList.remove('fade-out');
            }, 500);
        }

        setInterval(changeInfo, 5000);
    </script>
</body>
</html>