<?php 
require_once 'auth.php'; 

function getPrimeiroUltimoNome($nomeCompleto) {
    $stopwords = ['de', 'da', 'do', 'das', 'dos', 'e'];
    $nomeLimpo = strtolower(trim($nomeCompleto));
    $partesNome = explode(' ', $nomeLimpo);
    $partesSignificativas = array_values(array_diff($partesNome, $stopwords));
    if (count($partesSignificativas) === 0) return $nomeCompleto;
    if (count($partesSignificativas) === 1) return ucfirst($partesSignificativas[0]);
    $primeiroNome = ucfirst($partesSignificativas[0]);
    $ultimoNome = ucfirst(end($partesSignificativas));
    return $primeiroNome . ' ' . $ultimoNome;
}

function getSaudacao($sexo) {
    return ($sexo === 'Feminino') ? 'Bem-vinda' : 'Bem-vindo';
}

$configFile = 'admin/config.json';
$configData = file_exists($configFile) ? json_decode(file_get_contents($configFile), true) : [];
if ($configData === null) $configData = [];

$saudacao = getSaudacao($_SESSION['user_sexo']);
$nomeParaExibir = getPrimeiroUltimoNome($_SESSION['user_name']);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Intranet Biavatti</title>
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <link rel="stylesheet" href="style.css" />
    <style>
        .birthday-backdrop { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 33, 71, 0.8); backdrop-filter: blur(5px); z-index: 9999; display: flex; justify-content: center; align-items: center; opacity: 0; animation: fadeIn 0.5s forwards; }
        .birthday-card { background: white; color: var(--biavatti-dark-blue); padding: 40px; border-radius: 12px; text-align: center; transform: scale(0.7); animation: scaleIn 0.5s 0.3s forwards; }
        .birthday-card h2 { font-size: 2.5rem; color: var(--biavatti-accent-blue); margin: 0; }
        .birthday-card p { font-size: 1.2rem; margin: 15px 0 30px 0; }
        .birthday-card button { background: var(--biavatti-accent-blue); color: white; border: none; padding: 12px 30px; border-radius: 50px; cursor: pointer; font-size: 1rem; font-weight: 500; }
        @keyframes fadeIn { to { opacity: 1; } }
        @keyframes scaleIn { to { transform: scale(1); } }
    </style>
</head>
<body>
    <?php if (isset($_SESSION['is_birthday']) && $_SESSION['is_birthday'] === true): ?>
    <div class="birthday-backdrop" id="birthdayBackdrop">
        <div class="birthday-card">
            <h2>Feliz Aniversário!</h2>
            <p>A equipe da Clínica Biavatti deseja a você um dia incrível e um novo ciclo repleto de realizações!</p>
            <button onclick="document.getElementById('birthdayBackdrop').style.display='none'">Obrigado!</button>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>
    <script>confetti({ particleCount: 150, spread: 90, origin: { y: 0.6 } });</script>
    <?php unset($_SESSION['is_birthday']); ?>
    <?php endif; ?>

    <section class="hero-section">
      <div class="hero-overlay"></div>
      <div class="hero-content">
        <img src="imagem/cb_logo_bia.png" alt="Logo Clínica Biavatti" class="hero-logo"/>
        <h1><?php echo $saudacao; ?>, <?php echo htmlspecialchars($nomeParaExibir); ?>!</h1>
        <p>Você está na intranet da unidade <?php echo htmlspecialchars($_SESSION['user_unidade']); ?>.</p>
        <nav class="hero-navigation">
          <a href="https://intranet.clinicabiavatti.com.br/Intranet%20Rede%20Biavatti/index.php?r=user%2Fauth%2Flogin" target="_blank" class="hero-button-main">Acessar Área do Colaborador</a>

            <div class="hero-dropdown">
                <a class="hero-dropdown-trigger">Acesso Rápido</a>
                <div class="dropdown-content" id="quick-access-dropdown"></div>
            </div>
            <div class="hero-dropdown">
                <a class="hero-dropdown-trigger">Links Úteis</a>
                <div class="dropdown-content" id="useful-links-dropdown"></div>
            </div>
                        <a href="logout.php">Sair</a>
            
        </nav>
      </div>
    </section>
        <main class="main-container">
        <div class="card full-width-card" id="rankings-section">
            <h2 class="ranking-title-display"><i class="fas fa-star" style="color: #ffd700;"></i> Quadro de Honra</h2>
            <div class="carousel-wrapper" style="aspect-ratio: auto; min-height: 420px;">
                <div class="carousel-container"><div class="carousel-track"></div></div>
                <button class="carousel-btn prev-ranking-btn" aria-label="Anterior">&#10094;</button>
                <button class="carousel-btn next-ranking-btn" aria-label="Próximo">&#10095;</button>
            </div>
            <div class="carousel-indicators"></div>
        </div>

        <div class="card" id="image-carousel-section">
            <h2>Últimas Atualizações</h2>
            <div class="carousel-wrapper">
                <div class="carousel-container"><div class="carousel-track"></div></div>
                <button class="carousel-btn prev-btn" aria-label="Anterior">&#10094;</button>
                <button class="carousel-btn next-btn" aria-label="Próximo">&#10095;</button>
            </div>
            <div class="carousel-indicators"></div>
        </div>

        

        <div class="card full-width-card" id="news-section">
            <h2>Mural de Notícias</h2>
            <div id="news-container"></div>
        </div>
        
        <div class="card" id="birthdays-section">
            <h2>Aniversariantes do Mês</h2>
            <div id="birthdays-container"></div>
        </div>

        <div class="card" id="video-carousel-section">
            <h2>Vídeos Institucionais</h2>
            <div class="carousel-wrapper">
                <div class="carousel-container"><div class="carousel-track"></div></div>
                <button class="carousel-btn prev-video-btn" aria-label="Anterior">&#10094;</button>
                <button class="carousel-btn next-video-btn" aria-label="Próximo">&#10095;</button>
            </div>
            <div class="carousel-indicators"></div>
            <div class="video-title-container" id="video-title-display"></div>
        </div>
    </main>

    <footer>
      <div class="social-icons">
        <a href="https://www.instagram.com/clinicabiavatti/" target="_blank" rel="noopener noreferrer"><img src="icon/instagram.png" alt="Instagram"/></a>
        <a href="https://www.facebook.com/clinicabiavatti" target="_blank" rel="noopener noreferrer"><img src="icon/facebook.png" alt="Facebook"/></a>
        <a href="https://www.youtube.com/@ClinicaBiavatti" target="_blank" rel="noopener noreferrer"><img src="icon/youtube.png" alt="youtube"/></a>
      </div>
      <p>© <?php echo date('Y'); ?> Clínica Biavatti. Todos os direitos reservados.</p>
      <?php if (isset($_SESSION['user_cargo']) && $_SESSION['user_cargo'] === 'Administrador'): ?>
      <div class="admin-link-container">
        <a href="admin/painel.php" title="Acessar painel de controle" target="_blank" rel="noopener noreferrer">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <circle cx="12" cy="12" r="3"></circle>
            <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33A1.65 1.65 0 0 0 9 4.09V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06-.06a1.65 1.65 0 0 0-.33 1.82V15Z"></path>
          </svg>
        </a>
      </div>
      <?php endif; ?>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>
    <script src="script.js"></script>
</body>
</html>