<?php
require_once 'admin_header.php';

// Usando caminho local para XAMPP
$configFile = 'config.json';
$configData = file_exists($configFile) ? json_decode(file_get_contents($configFile), true) : [];
if (!isset($configData['rankings']) || !is_array($configData['rankings'])) {
    $configData['rankings'] = [];
}

$mensagem = ''; $erro = ''; $ranking_para_editar = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // AÇÃO: Adicionar ou Atualizar Título de Ranking
    if (isset($_POST['save_ranking'])) {
        $id = $_POST['ranking_id'];
        $titulo = trim($_POST['ranking_title']);
        if (!empty($titulo)) {
            if (empty($id)) { // Criando um novo ranking
                $configData['rankings'][] = ['id' => uniqid('ranking_'), 'titulo' => $titulo, 'vencedores' => []];
                $mensagem = "Ranking '".htmlspecialchars($titulo)."' criado com sucesso!";
            } else { // Atualizando um título existente
                foreach ($configData['rankings'] as $i => $ranking) {
                    if ($ranking['id'] === $id) { $configData['rankings'][$i]['titulo'] = $titulo; break; }
                }
                $mensagem = "Título do ranking atualizado com sucesso!";
            }
        } else { $erro = "O título do ranking não pode ser vazio."; }
    }

    // AÇÃO: Atualizar Vencedores
    if (isset($_POST['update_winners'])) {
        if (isset($_POST['winners']) && is_array($_POST['winners'])) {
            foreach ($configData['rankings'] as $i => $ranking) {
                $rankingId = $ranking['id'];
                if (isset($_POST['winners'][$rankingId])) {
                    $vencedoresData = $_POST['winners'][$rankingId];
                    $novosVencedores = [];
                    for ($p = 1; $p <= 3; $p++) {
                        if (!empty($vencedoresData['nome'][$p])) {
                            $novosVencedores[] = [ 'posicao' => $p, 'nome' => trim($vencedoresData['nome'][$p]), 'tipo' => $vencedoresData['tipo'][$p], 'foto' => trim($vencedoresData['foto'][$p]), 'score' => trim($vencedoresData['score'][$p]) ];
                        }
                    }
                    $configData['rankings'][$i]['vencedores'] = $novosVencedores;
                }
            }
        }
        $mensagem = 'Vencedores dos rankings atualizados com sucesso!';
    }
    
    // AÇÃO: Deletar um Ranking (agora funciona independentemente)
    if (isset($_POST['delete_ranking'])) {
        $idToDelete = $_POST['ranking_id'];
        $configData['rankings'] = array_filter($configData['rankings'], function($r) use ($idToDelete) { return $r['id'] !== $idToDelete; });
        $configData['rankings'] = array_values($configData['rankings']);
        $mensagem = 'Ranking removido com sucesso!';
    }
    
    file_put_contents($configFile, json_encode($configData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    $configData = json_decode(file_get_contents($configFile), true);
}

// LÓGICA PARA PREPARAR A EDIÇÃO DO TÍTULO
if (isset($_GET['action']) && $_GET['action'] === 'edit' && isset($_GET['id'])) {
    foreach ($configData['rankings'] as $ranking) {
        if ($ranking['id'] === $_GET['id']) {
            $ranking_para_editar = $ranking;
            break;
        }
    }
}
?>

<header>
    <h1>Gerenciar Rankings</h1>
    <a href="logout.php" class="btn-logout">Sair</a>
</header>

<div class="card">
    <?php if ($mensagem): ?><p class="message success"><?= $mensagem ?></p><?php endif; ?>
    <?php if ($erro): ?><p class="message error"><?= htmlspecialchars($erro) ?></p><?php endif; ?>

    <form method="post" class="add-ranking-form">
        <h2><?= $ranking_para_editar ? 'Editando Ranking' : 'Criar Novo Ranking' ?></h2>
        <input type="hidden" name="ranking_id" value="<?= htmlspecialchars($ranking_para_editar['id'] ?? '') ?>">
        <div class="form-group-inline">
            <input type="text" name="ranking_title" placeholder="Título do ranking" value="<?= htmlspecialchars($ranking_para_editar['titulo'] ?? '') ?>" required>
            <button type="submit" name="save_ranking" class="btn-add"><?= $ranking_para_editar ? 'Salvar Título' : 'Criar Ranking' ?></button>
            <?php if ($ranking_para_editar): ?>
                <a href="gerenciar_rankings.php" class="btn-cancel">Cancelar Edição</a>
            <?php endif; ?>
        </div>
    </form>
    <hr class="form-divider">

<h2>Gerenciar Vencedores</h2>
    <?php if (empty($configData['rankings'])): ?>
        <p>Nenhum ranking criado ainda. Use o formulário acima para começar.</p>
    <?php else: ?>
        <form method="post">
            <div class="rankings-management-grid">
                <?php foreach ($configData['rankings'] as $ranking): 
                    $vencedores = array_column($ranking['vencedores'] ?? [], null, 'posicao');
                    $rankingId = $ranking['id'];
                ?>
                <fieldset>
                    <legend><?= htmlspecialchars($ranking['titulo']) ?></legend>
                    <div class="ranking-actions">
                        <a href="?action=edit&id=<?= $rankingId ?>" class="btn-edit-title">Editar Título</a>
                        <!-- BOTÃO DE EXCLUSÃO CORRIGIDO: Agora é um botão que chama uma função JS -->
                        <button type="button" onclick="deleteRanking('<?= $rankingId ?>', '<?= htmlspecialchars(addslashes($ranking['titulo'])) ?>')" class="btn-remove-ranking">Excluir</button>
                    </div>
                    <?php for ($i = 1; $i <= 3; $i++): $vencedor = $vencedores[$i] ?? []; ?>
                    <div class="form-group-ranking">
                        <span class="position-badge"><?= $i ?>º</span>
                        <div class="winner-inputs">
                            <input type="text" name="winners[<?= $rankingId ?>][nome][<?= $i ?>]" value="<?= htmlspecialchars($vencedor['nome'] ?? '') ?>" placeholder="Nome do Vencedor">
                            <input type="text" name="winners[<?= $rankingId ?>][foto][<?= $i ?>]" value="<?= htmlspecialchars($vencedor['foto'] ?? '') ?>" class="image-url-input" placeholder="URL da foto">
                            <div class="image-preview-container"><img class="image-preview" src="" alt="Preview"></div>
                            <input type="text" name="winners[<?= $rankingId ?>][score][<?= $i ?>]" value="<?= htmlspecialchars($vencedor['score'] ?? '') ?>" placeholder="Pontuação / Descrição">
                            <select name="winners[<?= $rankingId ?>][tipo][<?= $i ?>]">
                                <option value="pessoa" <?= ($vencedor['tipo'] ?? 'pessoa') === 'pessoa' ? 'selected' : '' ?>>Pessoa</option>
                                <option value="clinica" <?= ($vencedor['tipo'] ?? '') === 'clinica' ? 'selected' : '' ?>>Clínica</option>
                            </select>
                        </div>
                    </div>
                    <?php endfor; ?>
                </fieldset>
                <?php endforeach; ?>
            </div>
            <button type="submit" name="update_winners" class="btn-save-all" style="margin-top: 20px;">Salvar Alterações nos Vencedores</button>
        </form>
    <?php endif; ?>
</div>

<style>
.add-ranking-form { margin-bottom: 20px; }
.form-group-inline { display: flex; gap: 10px; align-items: center; }
.form-group-inline input { flex-grow: 1; margin: 0; }
.form-group-inline button, .form-group-inline a { margin: 0; white-space: nowrap; }
.btn-cancel { background-color: #777; color: white; padding: 10px 15px; border-radius: 4px; text-decoration: none; }
.form-divider { border: 0; height: 1px; background: #ddd; margin: 30px 0; }
.rankings-management-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
fieldset { position: relative; border: 1px solid #ddd; padding: 20px; padding-top: 60px; border-radius: 8px; }
legend { font-weight: 600; color: var(--biavatti-dark-blue); font-size: 1.2rem; padding: 0 10px; }
.ranking-actions { position: absolute; top: 15px; right: 15px; display: flex; gap: 10px; }
.btn-edit-title { background: #5bc0de; color: white; padding: 5px 10px; font-size: 0.8rem; border-radius: 4px; text-decoration: none; }
.btn-remove-ranking { background: #d9534f; color: white; border: none; padding: 5px 10px; font-size: 0.8rem; border-radius: 4px; cursor: pointer; }
.form-group-ranking { display: flex; align-items: flex-start; gap: 10px; margin-bottom: 15px; }
.position-badge { font-weight: bold; background-color: #eee; padding: 10px; border-radius: 5px; min-width: 40px; text-align: center; margin-top: 5px; }
.winner-inputs { display: flex; flex-direction: column; gap: 5px; flex-grow: 1; }
.winner-inputs input, .winner-inputs select { margin-top: 0; }
.message { padding: 10px; border-radius: 5px; text-align: center; font-weight: bold; margin-bottom: 20px;}
.message.success { background-color: #dff0d8; color: #3c763d; }
.message.error { background-color: #f2dede; color: #a94442; }
@media (max-width: 900px) { .rankings-management-grid { grid-template-columns: 1fr; } }
</style>

<script>
// ===== NOVA FUNÇÃO JAVASCRIPT PARA EXCLUSÃO SEGURA =====
function deleteRanking(id, title) {
    if (confirm(`Tem certeza que deseja excluir o ranking "${title}"? Esta ação não pode ser desfeita.`)) {
        // Cria um formulário invisível
        const form = document.createElement('form');
        form.method = 'post';
        form.action = 'gerenciar_rankings.php'; // Envia para a mesma página

        // Adiciona o ID do ranking a ser deletado
        const idInput = document.createElement('input');
        idInput.type = 'hidden';
        idInput.name = 'ranking_id';
        idInput.value = id;
        form.appendChild(idInput);

        // Adiciona a ação de deletar
        const actionInput = document.createElement('input');
        actionInput.type = 'hidden';
        actionInput.name = 'delete_ranking';
        actionInput.value = '1'; // Apenas para que `isset($_POST['delete_ranking'])` funcione
        form.appendChild(actionInput);

        // Adiciona o formulário à página e o envia
        document.body.appendChild(form);
        form.submit();
    }
}
</script>

<?php require_once 'admin_footer.php'; ?>