<?php
// O header já inicia a sessão e faz a verificação de login
require_once 'admin_header.php';

// Crie um token CSRF se não existir
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$configFile = __DIR__ . '/../../dados_seguros/config.json'; 
$configData = json_decode(file_get_contents($configFile), true);

$mensagem = '';

// Lógica para salvar os dados quando o formulário é enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validação do Token CSRF para evitar ataques
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
       die('Falha na validação CSRF! Ação bloqueada.');
    }

    // Atualiza Slides do Carrossel
    $configData['carouselSlides'] = [];
    if(isset($_POST['slide_title'])) {
        for($i = 0; $i < count($_POST['slide_title']); $i++) {
            if(!empty($_POST['slide_title'][$i])) {
                $configData['carouselSlides'][] = [
                    'image' => filter_var($_POST['slide_image'][$i], FILTER_SANITIZE_URL),
                    'title' => htmlspecialchars($_POST['slide_title'][$i], ENT_QUOTES, 'UTF-8'),
                    'text' => htmlspecialchars($_POST['slide_text'][$i], ENT_QUOTES, 'UTF-8')
                ];
            }
        }
    }
    
    // Atualiza Acesso Rápido
    $configData['quickAccessLinks'] = [];
    if(isset($_POST['qa_text'])) {
        for($i = 0; $i < count($_POST['qa_text']); $i++) {
            if(!empty($_POST['qa_text'][$i])) {
                $configData['quickAccessLinks'][] = [
                    'text' => htmlspecialchars($_POST['qa_text'][$i], ENT_QUOTES, 'UTF-8'), 
                    'url' => filter_var($_POST['qa_url'][$i], FILTER_SANITIZE_URL)
                ];
            }
        }
    }

    // Atualiza Links Úteis
    $configData['usefulLinks'] = [];
    if(isset($_POST['ul_text'])) {
        for($i = 0; $i < count($_POST['ul_text']); $i++) {
            if(!empty($_POST['ul_text'][$i])) {
                $configData['usefulLinks'][] = [
                    'text' => htmlspecialchars($_POST['ul_text'][$i], ENT_QUOTES, 'UTF-8'), 
                    'url' => filter_var($_POST['ul_url'][$i], FILTER_SANITIZE_URL)
                ];
            }
        }
    }
    
    // Atualiza Notícias com Imagem
    $configData['news'] = [];
    if(isset($_POST['news_title'])) {
        for($i = 0; $i < count($_POST['news_title']); $i++) {
            if(!empty($_POST['news_title'][$i])) {
                $content = strip_tags($_POST['news_content'][$i], '<b><i><u><br>');
                $configData['news'][] = [
                    'title' => htmlspecialchars($_POST['news_title'][$i], ENT_QUOTES, 'UTF-8'), 
                    'content' => $content,
                    'image' => filter_var($_POST['news_image'][$i], FILTER_SANITIZE_URL),
                    'layout' => htmlspecialchars($_POST['news_layout'][$i] ?? 'image-left', ENT_QUOTES, 'UTF-8'),
                    'image_width' => intval($_POST['news_image_width'][$i] ?? 300),
                    'image_height' => intval($_POST['news_image_height'][$i] ?? 250)
                ];
            }
        }
    }

    // Atualiza Aniversariantes (Imagem Única)
    $configData['birthdayFlyerImage'] = filter_var($_POST['birthday_flyer_image'] ?? '', FILTER_SANITIZE_URL);

    // Atualiza Vídeos
    $configData['videos'] = [];
if(isset($_POST['video_title'])) {
    for($i = 0; $i < count($_POST['video_title']); $i++) {
        if(!empty($_POST['video_title'][$i])) {
            $configData['videos'][] = [
                'title' => htmlspecialchars($_POST['video_title'][$i], ENT_QUOTES, 'UTF-8'), 
                'url' => filter_var($_POST['video_url'][$i], FILTER_SANITIZE_URL),
                'preview' => filter_var($_POST['video_preview'][$i] ?? '', FILTER_SANITIZE_URL) // NOVO CAMPO
            ];
        }
    }
}

    // Salva o arquivo JSON atualizado e define a mensagem de sucesso
    if (file_put_contents($configFile, json_encode($configData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
        $mensagem = 'Dados salvos com sucesso!';
        // Recarrega os dados para exibir as alterações salvas imediatamente
        $configData = json_decode(file_get_contents($configFile), true);
    } else {
        $mensagem = 'Erro ao salvar os dados.';
    }
}
?>

<header>
    <h1>Gerenciar Conteúdo da Intranet</h1>
    <a href="logout.php" class="btn-logout">Sair</a>
</header>

<div class="card">
    <?php if ($mensagem): ?>
        <p class="message success"><?= $mensagem ?></p>
    <?php endif; ?>

    <form method="post">
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token']) ?>">

        <fieldset>
            <legend><h2>Últimas Atualizações (Carrossel)</h2></legend>
            <div id="slides-container">
                <?php if (!empty($configData['carouselSlides'])) { foreach($configData['carouselSlides'] as $slide): ?>
                <div class="form-group">
                    <button type="button" class="btn-remove" onclick="this.parentElement.remove()">Remover</button>
                    <label>Título:</label><input type="text" name="slide_title[]" value="<?= htmlspecialchars($slide['title']) ?>">
                    <label>Texto:</label><input type="text" name="slide_text[]" value="<?= htmlspecialchars($slide['text']) ?>">
                    <label>Caminho da Imagem:</label>
                    <input type="text" name="slide_image[]" class="image-url-input" value="<?= htmlspecialchars($slide['image']) ?>">
                    <div class="image-preview-container"><img class="image-preview" src="" alt="Preview"></div>
                </div>
                <?php endforeach; } ?>
            </div>
            <button type="button" class="btn-add" onclick="addGenericField('slides-container', 'slide')">+ Adicionar Slide</button>
        </fieldset>

        <fieldset>
            <legend><h2>Acesso Rápido</h2></legend>
            <div id="qa-container">
                <?php if (!empty($configData['quickAccessLinks'])) { foreach($configData['quickAccessLinks'] as $link): ?>
                <div class="form-group">
                     <button type="button" class="btn-remove" onclick="this.parentElement.remove()">Remover</button>
                    <label>Texto:</label><input type="text" name="qa_text[]" value="<?= htmlspecialchars($link['text']) ?>">
                    <label>URL:</label><input type="url" name="qa_url[]" value="<?= htmlspecialchars($link['url']) ?>">
                </div>
                <?php endforeach; } ?>
            </div>
            <button type="button" class="btn-add" onclick="addGenericField('qa-container', 'qa')">+ Adicionar Link</button>
        </fieldset>

         <fieldset>
            <legend><h2>Links Úteis</h2></legend>
            <div id="ul-container">
                <?php if (!empty($configData['usefulLinks'])) { foreach($configData['usefulLinks'] as $link): ?>
                <div class="form-group">
                     <button type="button" class="btn-remove" onclick="this.parentElement.remove()">Remover</button>
                    <label>Texto:</label><input type="text" name="ul_text[]" value="<?= htmlspecialchars($link['text']) ?>">
                    <label>URL:</label><input type="url" name="ul_url[]" value="<?= htmlspecialchars($link['url']) ?>">
                </div>
                <?php endforeach; } ?>
            </div>
            <button type="button" class="btn-add" onclick="addGenericField('ul-container', 'ul')">+ Adicionar Link</button>
        </fieldset>

        <fieldset>
            <legend><h2>Mural de Notícias</h2></legend>
            <div id="news-container-admin">
                <?php if (!empty($configData['news'])) { foreach($configData['news'] as $i => $news): ?>
                <div class="form-group">
                    <button type="button" class="btn-remove" onclick="this.parentElement.remove()">Remover</button>
                    <label>Título:</label>
                    <input type="text" name="news_title[]" value="<?= htmlspecialchars($news['title']) ?>">
                    
                    <label>Conteúdo:</label>
                    <div class="text-format-buttons">
                        <button type="button" onclick="formatText('b', <?= $i ?>)"><b>B</b></button>
                        <button type="button" onclick="formatText('i', <?= $i ?>)"><i>I</i></button>
                        <button type="button" onclick="formatText('u', <?= $i ?>)"><u>U</u></button>
                        <button type="button" onclick="formatText('br', <?= $i ?>)">Quebra de Linha</button>
                    </div>
                    <textarea id="news-content-<?= $i ?>" name="news_content[]" rows="6"><?= htmlspecialchars($news['content']) ?></textarea>
                    
                    <label>Caminho da Imagem (opcional):</label>
                    <input type="text" name="news_image[]" class="image-url-input" value="<?= htmlspecialchars($news['image'] ?? '') ?>">
                    <div class="image-preview-container"><img class="image-preview" src="" alt="Preview"></div>

                    <div style="display: flex; gap: 20px; margin-top: 10px;">
                        <div style="flex: 1;">
                            <label>Layout da Imagem:</label>
                            <select name="news_layout[]" onchange="toggleImageDimensions(this)">
                                <option value="image-left" <?= ($news['layout'] ?? '') === 'image-left' ? 'selected' : '' ?>>Imagem à Esquerda</option>
                                <option value="image-right" <?= ($news['layout'] ?? '') === 'image-right' ? 'selected' : '' ?>>Imagem à Direita</option>
                                <option value="image-center-top" <?= ($news['layout'] ?? '') === 'image-center-top' ? 'selected' : '' ?>>Imagem Centralizada (Acima)</option>
                                <option value="image-full" <?= ($news['layout'] ?? '') === 'image-full' ? 'selected' : '' ?>>Largura Total (Acima)</option>
                                <option value="image-full-bottom" <?= ($news['layout'] ?? '') === 'image-full-bottom' ? 'selected' : '' ?>>Largura Total (Abaixo)</option>
                            </select>
                        </div>
                        <div class="image-dimensions" style="display: flex; flex: 2; gap: 15px;">
                            <div style="flex: 1;">
                                <label>Largura Imagem (px):</label>
                                <input type="number" name="news_image_width[]" min="50" max="1000" value="<?= htmlspecialchars($news['image_width'] ?? '300') ?>" placeholder="ex: 300">
                            </div>
                            <div style="flex: 1;">
                                <label>Altura Imagem (px):</label>
                                <input type="number" name="news_image_height[]" min="50" max="1000" value="<?= htmlspecialchars($news['image_height'] ?? '250') ?>" placeholder="ex: 250">
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; } ?>
            </div>
            <button type="button" class="btn-add" onclick="addGenericField('news-container-admin', 'news')">+ Adicionar Notícia</button>
        </fieldset>

        <fieldset>
            <legend><h2>Aniversariantes do Mês</h2></legend>
            <div class="form-group">
                <label>Caminho da Imagem Única:</label>
                <input type="text" name="birthday_flyer_image" class="image-url-input" value="<?= htmlspecialchars($configData['birthdayFlyerImage'] ?? '') ?>" placeholder="ex: imagem/aniversariantes.jpg">
                <div class="image-preview-container"><img class="image-preview" src="" alt="Preview"></div>
            </div>
        </fieldset>

         <fieldset>
    <legend><h2>Vídeos Institucionais</h2></legend>
    <div id="videos-container">
        <?php if (!empty($configData['videos'])) { foreach($configData['videos'] as $video): ?>
        <div class="form-group">
             <button type="button" class="btn-remove" onclick="this.parentElement.remove()">Remover</button>
            <label>Título (para a legenda):</label>
            <input type="text" name="video_title[]" value="<?= htmlspecialchars($video['title']) ?>">
            
            <label>URL do Vídeo (do /embed do Youtube ou /preview do GDrive):</label>
            <input type="url" name="video_url[]" value="<?= htmlspecialchars($video['url']) ?>">

            <label>URL da Imagem de Preview (Opcional):</label>
            <input type="text" name="video_preview[]" class="image-url-input" value="<?= htmlspecialchars($video['preview'] ?? '') ?>" placeholder="Cole o link da imagem aqui">
            <div class="image-preview-container"><img class="image-preview" src="" alt="Preview"></div>
        </div>
        <?php endforeach; } ?>
    </div>
    <button type="button" class="btn-add" onclick="addGenericField('videos-container', 'video')">+ Adicionar Vídeo</button>
</fieldset>

        <button type="submit" class="btn-save-all">Salvar Todas as Alterações</button>
    </form>
</div>

<style>
/* Estilos específicos para esta página */
fieldset { border: 1px solid #ddd; padding: 20px; margin-bottom: 20px; border-radius: 8px; }
legend { font-weight: 600; color: var(--biavatti-dark-blue); font-size: 1.2rem; padding: 0 10px; }
.message { padding: 10px; margin-bottom: 15px; border-radius: 5px; text-align: center; font-weight: bold; }
.message.success { background-color: #dff0d8; color: #3c763d; }
.image-preview-container { text-align: left; }
.text-format-buttons { margin: -5px 0 10px 0; display: flex; gap: 5px; }
.text-format-buttons button { background-color: #e9e9e9; border: 1px solid #ccc; padding: 5px 10px; cursor: pointer; border-radius: 4px; font-size: 0.9rem; }
.text-format-buttons button:hover { background-color: #dcdcdc; }
</style>

<script>
    const fieldTemplates = {
        slide: `<button type="button" class="btn-remove" onclick="this.parentElement.remove()">Remover</button><label>Título:</label><input type="text" name="slide_title[]"><label>Texto:</label><input type="text" name="slide_text[]"><label>Caminho da Imagem:</label><input type="text" name="slide_image[]" class="image-url-input"><div class="image-preview-container"><img class="image-preview" src="" alt="Preview"></div>`,
        qa: `<button type="button" class="btn-remove" onclick="this.parentElement.remove()">Remover</button><label>Texto:</label><input type="text" name="qa_text[]"><label>URL:</label><input type="url" name="qa_url[]">`,
        ul: `<button type="button" class="btn-remove" onclick="this.parentElement.remove()">Remover</button><label>Texto:</label><input type="text" name="ul_text[]"><label>URL:</label><input type="url" name="ul_url[]">`,
        news: `<button type="button" class="btn-remove" onclick="this.parentElement.remove()">Remover</button>
                <label>Título:</label><input type="text" name="news_title[]" placeholder="Título da Notícia">
                <label>Conteúdo:</label>
                <div class="text-format-buttons">
                    <button type="button"><b>B</b></button><button type="button"><i>I</i></button><button type="button"><u>U</u></button><button type="button">Quebra de Linha</button>
                </div>
                <textarea name="news_content[]" rows="6"></textarea>
                <label>Caminho da Imagem (opcional):</label><input type="text" name="news_image[]" class="image-url-input" placeholder="ex: imagem/noticia.jpg">
                <div class="image-preview-container"><img class="image-preview" src="" alt="Preview"></div>
                <div style="display: flex; gap: 20px; margin-top: 10px;">
                    <div style="flex: 1;"><label>Layout da Imagem:</label><select name="news_layout[]" onchange="toggleImageDimensions(this)"><option value="image-left">Imagem à Esquerda</option><option value="image-right">Imagem à Direita</option><option value="image-center-top">Imagem Centralizada (Acima)</option><option value="image-full">Largura Total (Acima)</option><option value="image-full-bottom">Largura Total (Abaixo)</option></select></div>
                    <div class="image-dimensions" style="display: flex; flex: 2; gap: 15px;">
                        <div style="flex: 1;"><label>Largura Imagem (px):</label><input type="number" name="news_image_width[]" value="300"></div>
                        <div style="flex: 1;"><label>Altura Imagem (px):</label><input type="number" name="news_image_height[]" value="250"></div>
                    </div>
                </div>`,
        video: `<button type="button" class="btn-remove" onclick="this.parentElement.remove()">Remover</button>
        <label>Título (para a legenda):</label><input type="text" name="video_title[]">
        <label>URL do Vídeo (do /embed do Youtube ou /preview do GDrive):</label><input type="url" name="video_url[]">
        <label>URL da Imagem de Preview (Opcional):</label><input type="text" name="video_preview[]" class="image-url-input" placeholder="Cole o link da imagem aqui">
        <div class="image-preview-container"><img class="image-preview" src="" alt="Preview"></div>`
    };

    function addGenericField(containerId, templateName) {
        const container = document.getElementById(containerId);
        const newField = document.createElement('div');
        newField.className = 'form-group';
        newField.innerHTML = fieldTemplates[templateName];
        container.appendChild(newField);
        // Re-executa as funções de inicialização para os novos campos
        setupImagePreviews();
        initializeNewField(newField);
    }

    function toggleImageDimensions(selectElement) {
        const formGroup = selectElement.closest('.form-group');
        const dimensionsContainer = formGroup.querySelector('.image-dimensions');
        const widthInputDiv = dimensionsContainer.querySelector('input[name="news_image_width[]"]').parentElement;
        const heightInputDiv = dimensionsContainer.querySelector('input[name="news_image_height[]"]').parentElement;
        const layout = selectElement.value;

        dimensionsContainer.style.display = 'flex';
        if (layout.includes('full')) {
            widthInputDiv.style.display = 'none';
            heightInputDiv.style.display = 'block';
            widthInputDiv.querySelector('input').disabled = true;
            heightInputDiv.querySelector('input').disabled = false;
        } else if (layout.includes('center')) {
            dimensionsContainer.style.display = 'none';
            widthInputDiv.querySelector('input').disabled = true;
            heightInputDiv.querySelector('input').disabled = true;
        } else {
            widthInputDiv.style.display = 'block';
            heightInputDiv.style.display = 'block';
            widthInputDiv.querySelector('input').disabled = false;
            heightInputDiv.querySelector('input').disabled = false;
        }
    }

    function formatText(tag, index) {
        const textarea = document.getElementById(`news-content-${index}`);
        if (!textarea) return;
        const start = textarea.selectionStart;
        const end = textarea.selectionEnd;
        const selectedText = textarea.value.substring(start, end);
        let replacement;

        if (tag === 'br') {
            replacement = '<br>';
            textarea.value = textarea.value.substring(0, start) + replacement + textarea.value.substring(end);
            textarea.focus();
            textarea.selectionEnd = start + replacement.length;
        } else {
            replacement = `<${tag}>${selectedText}</${tag}>`;
            textarea.value = textarea.value.substring(0, start) + replacement + textarea.value.substring(end);
            textarea.focus();
            textarea.selectionEnd = start + replacement.length;
        }
    }

    // Função para inicializar campos recém-criados
    function initializeNewField(field) {
        // Encontra o seletor de layout e aplica a lógica de visibilidade
        const select = field.querySelector('select[name="news_layout[]"]');
        if (select) {
            toggleImageDimensions(select);
        }
        // Adiciona funcionalidade aos botões de formatação de texto
        const textButtons = field.querySelectorAll('.text-format-buttons button');
        const textarea = field.querySelector('textarea');
        if (textButtons.length > 0 && textarea) {
            const newIndex = document.querySelectorAll('textarea[name="news_content[]"]').length - 1;
            textarea.id = `news-content-${newIndex}`;
            textButtons[0].setAttribute('onclick', `formatText('b', ${newIndex})`);
            textButtons[1].setAttribute('onclick', `formatText('i', ${newIndex})`);
            textButtons[2].setAttribute('onclick', `formatText('u', ${newIndex})`);
            textButtons[3].setAttribute('onclick', `formatText('br', ${newIndex})`);
        }
    }

    // Executa no carregamento da página para campos existentes
    document.addEventListener('DOMContentLoaded', () => {
        document.querySelectorAll('select[name="news_layout[]"]').forEach(select => {
            toggleImageDimensions(select);
        });
    });
</script>

<?php require_once 'admin_footer.php'; ?>