<?php
session_start();
$isStandaloneAdmin = isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true;
$isUserAdmin = isset($_SESSION['intranet_loggedin']) && $_SESSION['intranet_loggedin'] === true 
             && isset($_SESSION['user_cargo']) && $_SESSION['user_cargo'] === 'Administrador';
if (!$isStandaloneAdmin && !$isUserAdmin) {
    header('Location: login.php');
    exit;
}
$currentPage = basename($_SERVER['SCRIPT_NAME']);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Painel de Controle - Intranet Biavatti</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <style>
        :root {
            --biavatti-dark-blue: #002147;
            --biavatti-accent-blue: #059cee;
            --biavatti-light-bg: #f4f6f8;
            --biavatti-white: #ffffff;
            --sidebar-width: 260px;
        }
        body { margin: 0; font-family: 'Poppins', sans-serif; background-color: var(--biavatti-light-bg); color: #333; }
        .admin-wrapper { display: flex; }
        .sidebar { width: var(--sidebar-width); background-color: var(--biavatti-dark-blue); color: var(--biavatti-white); height: 100vh; position: fixed; top: 0; left: 0; padding: 20px; box-sizing: border-box; }
        .sidebar-header { text-align: center; margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid rgba(255, 255, 255, 0.1); }
        .sidebar-header h2 { margin: 0; font-size: 1.5rem; }
        .sidebar-nav a { display: block; color: var(--biavatti-white); text-decoration: none; padding: 15px; border-radius: 8px; margin-bottom: 10px; transition: background-color 0.3s ease; }
        .sidebar-nav a:hover { background-color: rgba(255, 255, 255, 0.1); }
        .sidebar-nav a.active { background-color: var(--biavatti-accent-blue); font-weight: 600; }
        .main-content { margin-left: var(--sidebar-width); width: calc(100% - var(--sidebar-width)); padding: 20px; box-sizing: border-box; }
        .main-content header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .main-content header h1 { margin: 0; font-size: 1.8rem; color: var(--biavatti-dark-blue); }
        .btn-logout { background-color: #d9534f; color: white; padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: 500; }
        .card { background-color: var(--biavatti-white); padding: 25px; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); margin-bottom: 20px; }
        .form-group { margin-bottom: 15px; padding: 15px; background: #f9f9f9; border-radius: 4px; border: 1px solid #eee; }
        .form-group label { font-weight: bold; display: block; margin-bottom: 5px; }
        input, textarea, select { width: 100%; padding: 10px; box-sizing: border-box; margin-top: 5px; border: 1px solid #ccc; border-radius: 4px; font-family: 'Poppins', sans-serif;}
        .image-preview { margin-top: 10px; max-width: 150px; max-height: 100px; border-radius: 4px; border: 1px solid #ddd; object-fit: cover; }
        .btn-add, .btn-save-all { background: #5cb85c; color: white; padding: 10px 15px; border: none; border-radius: 4px; cursor: pointer; margin-top: 10px; font-size: 1rem; }
        .btn-remove { background: #d9534f; color: white; padding: 5px 8px; border: none; border-radius: 4px; cursor: pointer; float: right; }
    </style>
</head>
<body>
    <div class="admin-wrapper">
        <aside class="sidebar">
            <div class="sidebar-header">
                <h2>Intranet Biavatti</h2>
            </div>
            <nav class="sidebar-nav">
                <a href="painel.php" class="<?= $currentPage == 'painel.php' ? 'active' : '' ?>">Dashboard</a>
                <a href="gerenciar_conteudo.php" class="<?= $currentPage == 'gerenciar_conteudo.php' ? 'active' : '' ?>">Gerenciar Conteúdo</a>
                <a href="gerenciar_rankings.php" class="<?= $currentPage == 'gerenciar_rankings.php' ? 'active' : '' ?>">Gerenciar Rankings</a>
                <a href="gerenciar_usuarios.php" class="<?= $currentPage == 'gerenciar_usuarios.php' ? 'active' : '' ?>">Gerenciar Usuários</a>
                <a href="ver_log.php" class="<?= $currentPage == 'ver_log.php' ? 'active' : '' ?>">Log de Acesso</a>
            </nav>
        </aside>
        <main class="main-content">