        </main>
    </div>

    <script>
    // Função de Pré-visualização de Imagem
    function setupImagePreviews() {
        document.querySelectorAll('.image-url-input').forEach(input => {
            const previewContainer = input.nextElementSibling;
            if (previewContainer && previewContainer.classList.contains('image-preview-container')) {
                const previewImg = previewContainer.querySelector('.image-preview');
                
                // Função para atualizar a imagem
                const updatePreview = () => {
                    const url = input.value;
                    if (url) {
                        previewImg.src = url;
                        previewImg.style.display = 'block';
                    } else {
                        previewImg.style.display = 'none';
                    }
                };

                // Atualiza a imagem ao digitar
                input.addEventListener('input', updatePreview);
                
                // Mostra a imagem de erro se o link for inválido
                previewImg.onerror = () => {
                    // Se o próprio link do placeholder falhar, esconde a imagem para não mostrar um ícone quebrado
                    if (previewImg.src.includes('placehold.co')) {
                        previewImg.style.display = 'none';
                        return;
                    }
                    // A CORREÇÃO ESTÁ AQUI:
                    previewImg.src = 'https://placehold.co/150x100/EEE/333?text=Link%20Inválido';
                };

                // Executa uma vez no carregamento da página
                updatePreview();
            }
        });
    }

    // Chama a função no carregamento da página
    document.addEventListener('DOMContentLoaded', setupImagePreviews);
    </script>
</body>
</html>