/**
 * SISTEMX - MÓDULO VENDEDOR
 * Organizado por Módulos
 */

document.addEventListener('DOMContentLoaded', () => {
    
    // --- 1. CONFIGURAÇÕES E ESTADO ---
    let users = JSON.parse(localStorage.getItem('users')) || [];
    let comissoes = JSON.parse(localStorage.getItem('comissoes')) || [];
    let fechamentos = JSON.parse(localStorage.getItem('fechamentos')) || [];
    let currentUser = null;
    let editingIndex = null;

    // Garante Admin
    if (!users.some(u => u.login === 'Sousajss')) {
        users.push({ name: 'JOSIMAR SOUSA', login: 'Sousajss', pass: '81824467249', role: 'admin' });
        localStorage.setItem('users', JSON.stringify(users));
    }

    // --- 2. MÓDULO DE AUTENTICAÇÃO ---
    const Auth = {
        login: (login, pass) => {
            const user = users.find(u => u.login === login && u.pass === pass);
            if (!user) return alert('Usuário ou senha inválidos.');
            if (user.role === 'pendente') return alert('Seu acesso aguarda aprovação do Admin.');
            
            localStorage.setItem('loggedUserLogin', user.login);
            Auth.redirect(user);
        },
        logout: () => {
            localStorage.removeItem('loggedUserLogin');
            location.reload();
        },
        redirect: (user) => {
            if (user.role === 'admin') {
                window.location.href = 'Admin/admin.html';
            } else {
                currentUser = user;
                document.getElementById('login-screen').style.display = 'none';
                document.getElementById('app-content').style.display = 'block';
                document.getElementById('logged-user-name').textContent = user.name;
                UI.renderHome();
            }
        },
        checkSession: () => {
            const logged = localStorage.getItem('loggedUserLogin');
            if (logged) {
                const user = users.find(u => u.login === logged);
                if (user) Auth.redirect(user);
            }
        }
    };

    // --- 3. MÓDULO DE NEGÓCIO (COMISSÕES) ---
    const Business = {
        calcMetas: (vendedor, mes) => {
            const doMes = comissoes.filter(c => c.vendedor === vendedor && c.mesReferencia === mes && c.status !== 'Fechado');
            const totalVolume = doMes.reduce((acc, c) => acc + c.valorVenda + (c.valorAnterior || 0), 0);
            
            let perc = 1.9;
            if (totalVolume > 50000) perc = 3.8;
            if (totalVolume > 70000) perc = 5.5;

            comissoes.forEach(c => {
                if (c.vendedor === vendedor && c.mesReferencia === mes && c.status !== 'Fechado') {
                    c.comissaoPercentual = perc;
                    c.valorComissao = (c.valorVenda + (c.valorAnterior || 0)) * (perc / 100);
                }
            });
        },
        saveEntry: (dados) => {
            if (editingIndex !== null) {
                comissoes[editingIndex] = { ...comissoes[editingIndex], ...dados };
                editingIndex = null;
            } else {
                comissoes.push(dados);
            }
            Business.calcMetas(currentUser.name, dados.mesReferencia);
            localStorage.setItem('comissoes', JSON.stringify(comissoes));
            UI.renderHome();
        }
    };

    // --- 4. MÓDULO DE INTERFACE (UI) ---
    const UI = {
        renderHome: () => {
            const tbody = document.getElementById('comissoes-tbody');
            tbody.innerHTML = '';
            let sV = 0, sA = 0, sC = 0;
            const fmt = (v) => v.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' });

            comissoes.filter(c => c.vendedor === currentUser.name && c.status !== 'Fechado').forEach((c) => {
                const realIdx = comissoes.indexOf(c);
                sV += c.valorVenda; sA += c.valorAnterior; sC += c.valorComissao;
                
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td>${c.idVenda}</td>
                    <td>${c.mesReferencia}</td>
                    <td>${fmt(c.valorVenda)}</td>
                    <td>${c.revenda}</td>
                    <td>${fmt(c.valorAnterior)}</td>
                    <td>${fmt(c.valorComissao)} <span class="percent-tag">${c.comissaoPercentual}%</span></td>
                    <td><span class="status ${c.status === 'Pago' ? 'pago' : 'nao-pago'}">${c.status}</span></td>
                    <td><button class="acao-button edit-btn" onclick="window.editComm(${realIdx})"><i class="fa fa-edit"></i></button></td>
                `;
                tbody.appendChild(row);
            });

            document.getElementById('total-vendas').textContent = fmt(sV);
            document.getElementById('total-anterior').textContent = fmt(sA);
            document.getElementById('total-comissoes').textContent = fmt(sC);
            document.getElementById('total-volume').textContent = fmt(sV + sA);
            document.getElementById('total-comissoes-final').textContent = fmt(sC);
        },
        renderHistory: () => {
            const list = document.getElementById('history-list');
            list.innerHTML = '';
            const meusFechamentos = fechamentos.filter(f => f.itens.some(i => i.vendedor === currentUser.name));

            if (meusFechamentos.length === 0) {
                list.innerHTML = '<p>Nenhum fechamento arquivado.</p>';
                return;
            }

            meusFechamentos.forEach(f => {
                const totalV = f.itens.filter(i => i.vendedor === currentUser.name).reduce((acc, i) => acc + i.valorComissao, 0);
                const div = document.createElement('div');
                div.className = "form-container";
                div.innerHTML = `
                    <div style="display:flex; justify-content:space-between; align-items:center">
                        <strong>Lote Pago em: ${new Date(f.data).toLocaleDateString()}</strong>
                        <strong style="color:var(--success); font-size:1.2rem">Recebido: R$ ${totalV.toFixed(2)}</strong>
                    </div>
                `;
                list.appendChild(div);
            });
        },
        switchPanel: (panelId) => {
            document.getElementById('panel-home').style.display = panelId === 'home' ? 'block' : 'none';
            document.getElementById('panel-history').style.display = panelId === 'history' ? 'block' : 'none';
            document.getElementById('link-home').classList.toggle('active', panelId === 'home');
            document.getElementById('link-history').classList.toggle('active', panelId === 'history');
            if (panelId === 'history') UI.renderHistory();
        }
    };

    // --- 5. EVENT LISTENERS ---
    
    // Login Form
    document.getElementById('login-form').onsubmit = (e) => {
        e.preventDefault();
        Auth.login(document.getElementById('login-user').value, document.getElementById('login-pass').value);
    };

    // Logout
    document.getElementById('btn-logout').onclick = () => Auth.logout();

    // Toggle Cadastro
    document.getElementById('btn-show-register').onclick = () => {
        document.getElementById('login-form').style.display = 'none';
        document.getElementById('register-form').style.display = 'block';
    };
    document.getElementById('btn-show-login').onclick = () => {
        document.getElementById('register-form').style.display = 'none';
        document.getElementById('login-form').style.display = 'block';
    };

    // Registro
    document.getElementById('register-form').onsubmit = (e) => {
        e.preventDefault();
        const login = document.getElementById('reg-login').value;
        if (users.some(u => u.login === login)) return alert('Login já existe.');

        users.push({
            name: document.getElementById('reg-name').value,
            funcao: document.getElementById('reg-funcao').value,
            unidade: document.getElementById('reg-unidade').value,
            login: login,
            pass: document.getElementById('reg-pass').value,
            role: 'pendente'
        });
        localStorage.setItem('users', JSON.stringify(users));
        alert('Solicitação enviada! Aguarde aprovação.');
        location.reload();
    };

    // Sidebar
    document.getElementById('link-home').onclick = (e) => { e.preventDefault(); UI.switchPanel('home'); };
    document.getElementById('link-history').onclick = (e) => { e.preventDefault(); UI.switchPanel('history'); };

    // Form Comissão
    document.getElementById('revenda').onchange = (e) => {
        document.getElementById('group-revenda-detalhes').style.display = e.target.value === 'Sim' ? 'contents' : 'none';
    };

    document.getElementById('comissao-form').onsubmit = (e) => {
        e.preventDefault();
        const dados = {
            vendedor: currentUser.name,
            idVenda: document.getElementById('id-venda').value,
            valorVenda: parseFloat(document.getElementById('valor-venda').value),
            revenda: document.getElementById('revenda').value,
            dataAnterior: document.getElementById('data-anterior').value,
            valorAnterior: parseFloat(document.getElementById('valor-anterior').value) || 0,
            mesReferencia: document.getElementById('mes-referencia').value,
            dataCriacao: new Date().toISOString(),
            status: 'Não Pago'
        };
        Business.saveEntry(dados);
        e.target.reset();
        document.getElementById('group-revenda-detalhes').style.display = 'none';
    };

    // Salvar Manual
    document.getElementById('btn-save-manual').onclick = () => {
        localStorage.setItem('comissoes', JSON.stringify(comissoes));
        alert('Dados sincronizados com sucesso!');
    };

    // Global Edit
    window.editComm = (idx) => {
        const c = comissoes[idx];
        editingIndex = idx;
        document.getElementById('id-venda').value = c.idVenda;
        document.getElementById('valor-venda').value = c.valorVenda;
        document.getElementById('revenda').value = c.revenda;
        document.getElementById('revenda').dispatchEvent(new Event('change'));
        document.getElementById('mes-referencia').value = c.mesReferencia;
        if (c.revenda === 'Sim') {
            document.getElementById('data-anterior').value = c.dataAnterior;
            document.getElementById('valor-anterior').value = c.valorAnterior;
        }
        window.scrollTo(0,0);
    };

    // Init
    Auth.checkSession();
});